/* 
 *  MonitoredExecutor.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.request.ForceLogoutRequest;
import com.avaya.ccs.javafxrefclient.request.ForceNotReadyRequest;
import com.avaya.ccs.javafxrefclient.request.ForceReadyRequest;
import com.avaya.ccs.javafxrefclient.request.MonitorInteractionsRequest;
import com.avaya.ccs.javafxrefclient.request.MonitorUsersRequest;
import com.avaya.ccs.javafxrefclient.request.UnMonitorInteractionsRequest;
import com.avaya.ccs.javafxrefclient.request.UnMonitorUsersRequest;
import com.avaya.ccs.api.MonitoredInteractionI;
import com.avaya.ccs.api.MonitoredInteractionListenerI;
import com.avaya.ccs.api.MonitoredUserI;
import com.avaya.ccs.api.MonitoredUserListenerI;
import com.avaya.ccs.api.NotificationEventI;
import javafx.concurrent.Task;

public class MonitoredExecutor extends Executor implements MonitoredUserListenerI, MonitoredInteractionListenerI {

    private static final Logger LOG = Logger.getLogger(MonitoredExecutor.class);
    private final JavaFXRefClient gui;

    public MonitoredExecutor(JavaFXRefClient gui) {
        this.gui = gui;
    }

    public void monitorUsers(String userID) {
        String methodName = "monitorUsers() ";
        LOG.debug(methodName + "+ UserID:" + userID);
        executeOutgoingRequest(new MonitorUsersRequest(this, userID));
        LOG.trace(methodName + "-");
    }

    public void unMonitorUsers(String userID) {
        String methodName = "unMonitorUsers() ";
        LOG.debug(methodName + "+ UserID:" + userID);
        executeOutgoingRequest(new UnMonitorUsersRequest(userID));
        LOG.trace(methodName + "-");
    }

    public void monitorInteractions(String superID, String userID) {
        String methodName = "monitorInteractions() ";
        LOG.debug(methodName + "+ SupervisorID" + superID + "UserID:" + userID);
        executeOutgoingRequest(new MonitorInteractionsRequest(this, superID, userID));
        LOG.trace(methodName + "-");
    }

    public void unMonitorInteractions(String superID, String userID) {
        String methodName = "unMonitorInteractions() ";
        LOG.debug(methodName + "+ SupervisorID" + superID + "UserID:" + userID);
        executeOutgoingRequest(new UnMonitorInteractionsRequest(superID, userID));
        LOG.trace(methodName + "-");
    }

    public void forceReady(String superID, String userID) {
        String methodName = "forceReady() ";
        LOG.debug(methodName + "+ SupervisorID" + superID + "UserID:" + userID);
        executeOutgoingRequest(new ForceReadyRequest(superID, userID));
        LOG.trace(methodName + "-");
    }

    public void forceNotReady(String superID, String userID) {
        String methodName = "forceNotReady() ";
        LOG.debug(methodName + "+ SupervisorID" + superID + "UserID:" + userID);
        executeOutgoingRequest(new ForceNotReadyRequest(superID, userID));
        LOG.trace(methodName + "-");
    }

    public void forceLogout(String superID, String userID) {
        String methodName = "forceLogout() ";
        LOG.debug(methodName + "+ SupervisorID" + superID + "UserID:" + userID);
        executeOutgoingRequest(new ForceLogoutRequest(superID, userID));
        LOG.trace(methodName + "-");
    }

    @Override
    public void onMonitoredUserEvent(NotificationEventI<MonitoredUserI> monitoredUser) {
        String methodName = "onMonitoredUserEvent() ";
        LOG.info(methodName + monitoredUser.getNotificationType() + " MonitoredUserI-ID:"
                + monitoredUser.getNotificationObject().getId());
        Task<MonitoredUserData> t = new MonitoredUserEventTask(monitoredUser, gui.getSupervisorGUI());
        executeIncomingEvent(t);
    }

    @Override
    public void onMonitoredInteractionEvent(NotificationEventI<MonitoredInteractionI> nei) {
        String methodName = "onMonitoredInteractionEvent() ";
        LOG.debug(methodName + nei.getNotificationType() + " MonitoredInteractionI-ID:"
                + nei.getNotificationObject().getId());
        Task<MonitoredInteractionData> t = new MonitoredInteractionEventTask(nei, gui.getSupervisorGUI());
        executeIncomingEvent(t);
    }
}
